/*
 * Created on 14 avr. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.cocoon.generators;

import java.io.IOException;
import java.rmi.ServerException;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AbstractXMLConsumer;
import org.apache.log4j.Logger;
import org.injac.utils.WebdavConnection;
import org.xml.sax.SAXException;

/**
 * @author shoam
 *
 * Return a webdavresource from src
 * parameters : 
 * 	- login (optional)
 * 	- password (optional)
 *  - published (optional) : if set to TRUE, filter published resource.
 * 		behaviour : 
 * 		If not published, return a docbook error xml instead of asked resource
 * 
 */
public class WebdavFileGenerator extends ServiceableGenerator implements
		Generator {

	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(WebdavFileGenerator.class);

	/**
	 * Connection with session management
	 * 
	 * @uml.property name="webdavConnection"
	 * @uml.associationEnd multiplicity="(0 1)"
	 */
	private WebdavConnection webdavConnection;

	/**
	 * name of the requested directory
	 */
	private String directory;
	/**
	 * The dav ressource uri
	 */
	private String webdavpath;
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	/**
	 * Published filter flag
	 */
	private boolean publishedOnly;

	/**
     * -Set the request parameters. Must be called before the generate method.
     * -Stock keys for caching.
     *
     * @param resolver     the SourceResolver object
     * @param objectModel  a <code>Map</code> containing model object
     * @param src          the directory to be XMLized specified as src attribute on &lt;map:generate/>
     * @param par          configuration parameters
     * 
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par)
            throws ProcessingException, SAXException, IOException {
        if (src == null) {
            throw new ProcessingException("No src attribute pointing to a Webdav resource whom metadas to be XMLized specified.");
        }
        super.setup(resolver, objectModel, src, par);
        directory= src.substring(src.lastIndexOf('/')+1);
        logger.debug("directory : "+directory);
        
        this.webdavpath = src;	
        webdavConnection = new WebdavConnection(objectModel);
        
        //      Rcupration des credentials
		try {
			login=par.getParameter("login");
			password=par.getParameter("password");
		}
		catch(Exception e)
		{
			login=null;
			password=null;
		}
		try {
			publishedOnly=par.getParameterAsBoolean("published");
			
		}
		catch(Exception e)
		{
			publishedOnly=true;
		}
        // 2. Connect to webdavresource
        try {
			connect(webdavpath);
			logger.debug("WebdavFileGenerator::setup : connection ressource : "+webdavpath+ " okay");
        }catch(Exception e)
		{
        	logger.error("WebdavFileGenerator::setup : Can't establish webdav connection : "+webdavpath+"\nCheck either URI is incorrect or login/password error.\n"+e.getMessage());
        	
		}
    }

	/* (non-Javadoc)
	 * @see org.apache.cocoon.generation.Generator#generate()
	 */
	public void generate() throws IOException, SAXException,
			ProcessingException {
		if(publishedOnly && !checkPublished())
		{
			// return error docbook
			
			return;
		}
		this.contentHandler.startDocument();
		
		this.contentHandler.endDocument();
	}
	
	private boolean checkPublished()
	{
		return true;
	}
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		logger.info("WebdavFileGenerator::connect try to connect webdavpath : "+webdavpath+"\nlogin : "+login);
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }
		
		logger.info("WebdavFileGenerator::connect ---> OK");
	}

}
